#include <algorithm>
#include <cstdint>
#include <iostream>
#include <vector>

using namespace std;


struct BeforeAfter {
    int before = -1;
    int after = -1;
};

struct Coordinate {
    int x;
    int y;
    int index;

    bool operator< (const Coordinate &other) const {
        return x < other.x;
    }
};

void generateClosestVector(const vector<Coordinate>& coordinates, vector<BeforeAfter>& closestLarger) {
    int n = coordinates.size();

    for (int i = 1; i < n; i++) {
        if (coordinates[i].y <= coordinates[i - 1].y) {
            closestLarger[i].before = i-1;
        }

        else {
            int candidateIndex = closestLarger[i - 1].before;

            while (candidateIndex != -1) {
                if (coordinates[i].y <= coordinates[candidateIndex].y) {
                    closestLarger[i].before = candidateIndex;

                    break;
                }

                candidateIndex = closestLarger[candidateIndex].before;
            }
        }
    }

    for (int i = n - 2; i >= 0; i--) {
        if (coordinates[i].y <= coordinates[i + 1].y) {
            closestLarger[i].after = i+1;
        }

        else {
            int candidateIndex = closestLarger[i + 1].after;

            while (candidateIndex != -1) {
                if (coordinates[i].y <= coordinates[candidateIndex].y) {
                    closestLarger[i].after = candidateIndex;

                    break;
                }

                candidateIndex = closestLarger[candidateIndex].after;
            }
        }
    }
}

int main() {
    int n;

    cin >> n;

    vector<Coordinate> coordinates(n);

    for (int i = 0; i < n; i++) {
        cin >> coordinates[i].x;
    }

    for (int i = 0; i < n; i++) {
        cin >> coordinates[i].y;
        coordinates[i].index = i;
    }

    sort(coordinates.begin(), coordinates.end());

    vector<BeforeAfter> closestLarger(n);

    vector<int> reverseMap(n);
    for (int i = 0; i < n; i++) {
        reverseMap[coordinates[i].index] = i;
    }

    generateClosestVector(coordinates, closestLarger);

    for (int i = 0; i < n; i++) {
        const int index = reverseMap[coordinates[i].index];

        if (closestLarger[index].before == -1 && closestLarger[index].after == -1) cout << -1 << endl;

        else if (closestLarger[index].before == -1) {
            const int closestLargerIndex = closestLarger[index].after;

            cout << coordinates[closestLargerIndex].x - coordinates[closestLargerIndex].y + coordinates[index].y - coordinates[index].x << endl;
        }

        else if (closestLarger[index].after == -1) {
            const int closestLargerIndex = closestLarger[index].before;

            cout << coordinates[index].x - coordinates[closestLargerIndex].x - coordinates[closestLargerIndex].y + coordinates[index].y << endl;
        }

        else {
            const int closestLargerIndexA = closestLarger[index].after;
            int da = coordinates[closestLargerIndexA].x - coordinates[closestLargerIndexA].y + coordinates[index].y - coordinates[index].x;

            const int closestLargerIndexB = closestLarger[index].before;
            int db = coordinates[index].x - coordinates[closestLargerIndexB].x - coordinates[closestLargerIndexB].y + coordinates[index].y;

            cout << min(da, db) << endl;
        }
    }

    return 0;
}